<?php
// test_db.php

$host = 'localhost';              // Servidor MySQL
$db   = 'daniel';        // 👈 nombre EXACTO de tu base de datos (míralo en phpMyAdmin)
$user = 'daniel';                 // Usuario MySQL
$pass = 'Daniel@123456';          // Contraseña MySQL

try {
    // Conectamos usando PDO
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
    echo "✅ Conexión exitosa a la base de datos<br>";

    // Probamos una consulta
    $stmt = $pdo->query("SELECT * FROM examen_usuarios LIMIT 5"); // 👈 nombre correcto de tu tabla
    $filas = $stmt->fetchAll();

    if ($filas) {
        echo "✅ Consulta exitosa, se obtuvieron " . count($filas) . " registros.<br>";
        echo "<pre>";
        print_r($filas);
        echo "</pre>";
    } else {
        echo "ℹ️ La tabla examen_usuarios está vacía o no contiene registros.<br>";
    }

} catch (PDOException $e) {
    echo "❌ Error conexión: " . $e->getMessage();
}



function csrf_get_token() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }

    // 🔹 Forzar el token en cada carga (para depurar)
    return $_SESSION['csrf_token'];
}

require_once __DIR__ . '/../includes/mailer.php';
enviar_correo('danielalbertoperezlopez3@gmail.com', 'Prueba de correo', '<p>¡Funciona correctamente!</p>');
echo "✅ Correo de prueba enviado (si no llega, revisa spam)";
