<?php

if (session_status() === PHP_SESSION_NONE) session_start();

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/mailer.php'; 

// --- Seguridad ---
if (empty($_SESSION['user']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header('Location: login.php');
    exit;
}


// --- Crear tablas auxiliares si no existen (mensajes programados y chat) ---
$pdo->exec("
CREATE TABLE IF NOT EXISTS examen_mensajes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT DEFAULT NULL,
    destinatario_email VARCHAR(255) DEFAULT NULL,
    role_destinatario ENUM('user','admin') DEFAULT NULL,
    asunto VARCHAR(255) NOT NULL,
    mensaje TEXT NOT NULL,
    enviado TINYINT(1) DEFAULT 0,
    fecha_nacimiento DATETIME DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES examen_usuarios(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");



// --- Helper: safe input ---
function in_s($k) { return trim($_POST[$k] ?? ''); }

// --- CSRF + action handling ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['action'])) {
    if (!csrf_check_token($_POST['csrf'] ?? '')) {
        http_response_code(400);
        echo "CSRF inválido";
        exit;
    }

    $action = $_POST['action'];

    try {
        if ($action === 'update_role') {
            // actualizar role de usuario 
            $uid = (int)($_POST['user_id'] ?? 0);
            $role = in_s('role');
            if (!in_array($role, ['user','admin'])) throw new Exception('Role inválido');
            $stmt = $pdo->prepare("UPDATE examen_usuarios SET role = ? WHERE id = ?");
            $stmt->execute([$role, $uid]);
            echo "ok";
            exit;
        }

       

      

        if ($action === 'send_mail') {
            // enviar inmediato o programado
            $user_email = filter_var(in_s('destinatario_email'), FILTER_VALIDATE_EMAIL) ? in_s('destinatario_email') : null;
            $role_dest = in_s('role_destinatario') ?: null;
            $asunto = in_s('asunto');
            $mensaje = in_s('mensaje');
            $fecha_programada = in_s('fecha_programada') ?: null;

            if ($fecha_programada) {
                // si fecha_programada viene en formato HTML datetime-local -> convertimos
                $fecha_programada = str_replace('T', ' ', $fecha_programada);
                // Guardar en examen_mensajes
                $stmt = $pdo->prepare("INSERT INTO mensajes_mensajes (destinatario_email, role_destinatario, asunto, mensaje, fecha_programada) VALUES (?, ?, ?, ?, ?)");
                $stmt->execute([$user_email, $role_dest, $asunto, $mensaje, $fecha_programada]);
                echo "scheduled";
                exit;
            } else {
                // envío inmediato: usar función del mailer (puede ser send_panel_email o enviar_correo)
                if ($user_email) {
                    $ok = enviar_correo($user_email, $asunto, $mensaje);
                } elseif ($role_dest) {
                    // obtener emails del rol
                    $stmt = $pdo->prepare("SELECT email FROM examen_usuarios WHERE role = ?");
                    $stmt->execute([$role_dest]);
                    $emails = $stmt->fetchAll(PDO::FETCH_COLUMN);
                    $ok = true;
                    foreach ($emails as $e) {
                        if (!enviar_correo($e, $asunto, $mensaje)) $ok = false;
                    }
                } else {
                    throw new Exception('Destino no especificado');
                }
                echo $ok ? 'sent' : 'error';
                exit;
            }
        }

     

     

    
if ($action === 'add_discount') {
            $user_id = (int)($_POST['user_id'] ?? 0);
            $descripcion = in_s('descripcion');
            $cantidad = (float)($_POST['cantidad'] ?? 0);
              $tipo = in_s('tipo') ?: 'porcentaje';

              if (!$uid || !$descripcion || $cantidad <= 0) {
        throw new Exception('Datos incompletos del descuento');
    }
            $stmt = $pdo->prepare("INSERT INTO examen_descuentos (user_id, descripcion, cantidad, tipo, fecha) VALUES (?, ?, ?, ?, CURDATE())");
            $stmt->execute([$uid, $descripcion, $cantidad, $tipo]);

            echo "<script>alert('Descuento agregado correctamente');location.href='dashboard_admin.php';</script>";
            exit;
        }
        // si no coincide acción:
        throw new Exception('Acción desconocida');

    } catch (Exception $ex) {
        http_response_code(400);
        echo 'error: ' . e($ex->getMessage());
        exit;
    }
}

// --- Consultas para mostrar datos ---
$users = $pdo->query("SELECT id, email, Nombre, telefono, Apellidos, DNI,fecha_nacimiento, role FROM examen_usuarios WHERE role <> 'admin' ORDER BY email ASC")->fetchAll(PDO::FETCH_ASSOC);



// pequeñas cabeceras de seguridad para JS fetch
header('X-Frame-Options: DENY');
header('X-Content-Type-Options: nosniff');
header('Referrer-Policy: no-referrer');


if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($_POST['action'])) {

    if (!csrf_check_token($_POST['csrf'] ?? '')) {
        die("CSRF inválido");
    }

    $nombre = in_s('nombre');
    $apellidos = in_s('apellidos');
    $dni = in_s('dni');
    $email = in_s('email');
    $fecha_nacimiento = in_s('fecha_nacimiento');
    $telefono = in_s('telefono');
      //  Verificar si el DNI ya existe
    $check = $pdo->prepare("SELECT id FROM examen_usuarios WHERE dni = ?");
    $check->execute([$dni]);

    if ($check->fetch()) {
        echo "<script>alert(' Este DNI ya está registrado. No se puede duplicar.');history.back();</script>";
        exit;
    }

    // Contraseña temporal (todas iguales)
    $passwordTemporal = "TEMPORAL123";
    $passwordHash = password_hash($passwordTemporal, PASSWORD_DEFAULT);

    // Generar token de recuperación
    $token = bin2hex(random_bytes(32));
    $expira = date("Y-m-d H:i:s", strtotime("+24 hours")); // Expira en 24h

    // Insert
    $stmt = $pdo->prepare("
        INSERT INTO examen_usuarios (nombre, apellidos, dni, email, fecha_nacimiento, telefono, password, role, token, token_expira)
        VALUES (?, ?, ?, ?, ?, ?, ?, 'user', ?, ?)
    ");
    $stmt->execute([$nombre, $apellidos, $dni, $email, $fecha_nacimiento, $telefono, $passwordHash, $token, $expira]);

    // Link para crear contraseña
    $link = "https://daniel.guiaviaje.com/examenes/3/html/recover_reset.php?token=$token";

    // Enviar correo
    enviar_correo($email, "Bienvenido - Crea tu contraseña", "
        Hola <b>$nombre</b>,<br><br>
        Tu cuenta ha sido creada.<br><br>
        Para establecer tu contraseña, haz clic en el siguiente enlace:<br><br>
        <a href='$link'>$link</a><br><br>
        El enlace expirará en 24 horas.<br><br>
        Si no hiciste esta solicitud, ignora este mensaje.
    ");

    echo "<script>alert('Usuario registrado y email enviado.');location.href='dashboard_admin.php';</script>";
    exit;
}
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Panel Administrador</title>
<link rel="stylesheet" href="assets/css/style_usuario.css">
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>

table{border-collapse:collapse;width:100%}
th,td{padding:6px;border:1px solid #ddd}
form.inline{display:inline}
.section{margin:18px 0;padding:10px;border:1px solid #eee;background:#fafafa}
.chat-box{max-height:300px;overflow:auto;border:1px solid #ddd;padding:8px;background:#fff}
.chat-msg{margin-bottom:8px}
.admin-msg{color:blue}
.user-msg{color:green}
</style>
</head>
<body>
<h1>Panel Administrador</h1>
<p>Has iniciado sesión como <strong><?= e($_SESSION['user']['nombre'] ?? 'admin') ?></strong> — rol: admin</p>
<p><a href="index.php">Inicio</a> | <a href="logout.php">Salir</a></p>

<!--  Usuario  -->
<div class="section" id="users">

  <table>
    <h3>Usuarios Registrados</h3>
<table border="1" cellpadding="5">
<tr><th>Email</th><th>Nombre</th><th>Apellidos</th><th>Telefono</th><th>Fecha de Nacimiento</th><th>Role</th></tr>
<?php foreach($users as $u): ?>
<tr>
<td><?= e($u['email']) ?></td>
<td><?= e($u['Nombre']) ?></td>
<td><?= e($u['Apellidos']) ?></td>
<td><?= e($u['telefono']) ?></td>
<td><?= e($u['fecha_nacimiento']) ?></td>
<td><?= e($u['role']) ?></td>
</tr>
<?php endforeach; ?>


</table>
   
</div>
    
<!-- Asignar Descuento -->
<div class="section">
<h2>Agregar Descuento Manual</h2>

<form method="post">
<input type="hidden" name="csrf" value="<?= e(csrf_get_token()) ?>">
<input type="hidden" name="action" value="add_discount">

<label>Usuario</label>
<select name="user_id" required>
<option value="">-- seleccionar usuario --</option>
<?php foreach($users as $u): ?>
<option value="<?= $u['id'] ?>"><?= e($u['Nombre'].' '.$u['Apellidos'].' - '.$u['email']) ?></option>
<?php endforeach; ?>
</select>

<label>Descripción del descuento</label>
<input type="text" name="descripcion" placeholder="Ej: Descuento especial fidelización" required>

<label>Cantidad</label>
<input type="number" name="cantidad" step="0.01" placeholder="Ej: 10" required>

<label>Tipo</label>
<select name="tipo">
<option value="porcentaje">%</option>
<option value="euros">€</option>
</select>

<button type="submit">Guardar Descuento</button>
</form>


<h2>Registro de usuario</h2>

<form method="post">
<input type="hidden" name="csrf" value="<?= e(csrf_get_token()) ?>">

<table>
<tr><th>Nombre</th><td><input type="text" name="nombre" required></td></tr>
<tr><th>Apellidos</th><td><input type="text" name="apellidos" required></td></tr>
<tr><th>DNI/NIF</th><td><input type="text" name="dni" required></td></tr>
<tr><th>Email</th><td><input type="email" name="email" required></td></tr>
<tr><th>Fecha Nacimiento</th><td><input type="date" name="fecha_nacimiento" required></td></tr>
<tr><th>Teléfono</th><td><input type="text" name="telefono" required></td></tr>
</table>

<!-- CONTRASEÑA TEMPORAL -->
<input type="hidden" name="password" value="TEMPORAL123">

<input type="submit" value="Registrar" class="submit">
</form>
<!--  Envío de correos  -->
<div class="section">
  <h2>Enviar correos (uno a uno / por rol / programado)</h2>
  <form id="sendMailForm" class="admin-ajax" method="post" data-action="send_mail">
    <input type="hidden" name="csrf" value="<?= e(csrf_get_token()) ?>">
    <input type="hidden" name="action" value="send_mail">
    <label>Destinatario (email)</label>
    <input name="destinatario_email" placeholder="correo@ejemplo.com">

    <label>O enviar a rol</label>
    <select name="role_destinatario">
      <option value="">-- todos --</option>
      <option value="user">Usuarios</option>
      <option value="admin">Administradores</option>
     
    </select>

    <label>Asunto</label>
    <input name="asunto" required>

    <label>Mensaje (HTML ok)</label>
    <textarea name="mensaje" required></textarea>

    <label>Fecha programada (opcional)</label>
    <input type="datetime-local" name="fecha_programada">

    <button type="submit">Enviar / Programar</button>
  </form>
</div>

</body>
</html>
