<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/functions.php';

//  Iniciar sesión si no está iniciada
if (session_status() === PHP_SESSION_NONE) session_start();

//  Solo usuarios con rol 'user' pueden enviar incidencias
if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'user') {
    http_response_code(403);
    die("Acceso denegado");
}

//  Verificar método POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die("Método no permitido");
}

// Verificar CSRF
$csrf = $_POST['csrf'] ?? '';
if (!csrf_check_token($csrf)) {
    http_response_code(400);
    die("Token CSRF inválido");
}

// Validar mensaje
$mensaje = trim($_POST['mensaje'] ?? '');
if (empty($mensaje)) {
    die("El mensaje no puede estar vacío");
}

//  Valor inicial del estado
$estado_inicial = 'Pendiente'; 

//  Insertar incidencia en la base de datos
try {
    $stmt = $pdo->prepare("
        INSERT INTO reformas_incidencias (user_id, mensaje, estado, fecha)
        VALUES (:user_id, :mensaje, :estado, NOW())
    ");
    $stmt->execute([
        ':user_id' => $_SESSION['user']['id'],
        ':mensaje' => $mensaje,
        ':estado'  => $estado_inicial
    ]);

    // Redirigir al panel de usuario con mensaje de éxito
    header('Location: ../dashboard_user.php?success=incidencia');
    exit;

} catch (PDOException $e) {
    error_log("Error al insertar incidencia: " . $e->getMessage());
    http_response_code(500);
    die("Ocurrió un error al enviar la incidencia. Intenta nuevamente.");
}
