<?php
if (session_status() === PHP_SESSION_NONE) session_start();

require_once __DIR__.'/../includes/config.php';
require_once __DIR__.'/../includes/functions.php';

header('Content-Type: application/json');

if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'tech') {
    http_response_code(403);
    echo json_encode(['error' => 'Acceso denegado']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !csrf_check_token($_POST['csrf'] ?? '')) {
    http_response_code(400);
    echo json_encode(['error' => 'CSRF inválido o método no permitido']);
    exit;
}

$comando = trim($_POST['comando'] ?? '');
$descripcion = trim($_POST['descripcion'] ?? '');

if (!$comando) {
    echo json_encode(['error' => 'Comando vacío']);
    exit;
}

$tipoComando = strtoupper(strtok($comando, " "));
$permitidos = ['SELECT','CREATE','ALTER','INSERT','UPDATE','DELETE'];

if (!in_array($tipoComando, $permitidos)) {
    echo json_encode(['error' => "Tipo de comando no permitido: $tipoComando"]);
    exit;
}

try {
    $stmt = $pdo->prepare($comando);
    $stmt->execute();

    $resultado = null;
    if ($tipoComando === 'SELECT') {
        $resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Guardar historial
    $historial = $pdo->prepare("
        INSERT INTO reformas_comandos (user_id, comando, descripcion, tipo)
        VALUES (?, ?, ?, ?)
    ");
    $historial->execute([
        $_SESSION['user']['id'],
        $comando,
        $descripcion,
        $tipoComando
    ]);

    echo json_encode([
        'success' => true,
        'tipo' => $tipoComando,
        'resultado' => $resultado,
        'descripcion' => $descripcion
    ]);

} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
