<?php
// api/admin_fetch_chat.php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__.'/../includes/config.php';
require_once __DIR__.'/../includes/functions.php';
if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') { http_response_code(403); exit; }
$uid = (int)($_GET['user_id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM reformas_chat WHERE user_id = ? ORDER BY id ASC");
$stmt->execute([$uid]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($rows as &$r) {
  $r['message_html'] = nl2br(htmlspecialchars($r['message'], ENT_QUOTES, 'UTF-8'));
}
header('Content-Type: application/json');
echo json_encode($rows);
